package threadgroup2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * Many Producer, Consumer in ThreadGroups.
 * 
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 06.05.2007
 */
public class ProdConDemo {

	public static void main(String args[]) {
		Depot depot = new Depot();
		Producer producer1 = new Producer(depot);
		Producer producer2 = new Producer(depot);
		Consumer consumer = new Consumer(depot);
		
		ThreadGroup producerGroup = new ThreadGroup("Producers");
		
		new Thread(producerGroup,producer1,"Producer1").start();
		new Thread(producerGroup,producer2,"Producer2").start();
		consumer.start();
		
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		
		
		try {
			br.readLine();
		} catch (IOException e) { }
		
		ThreadGroup top = producerGroup;
		while (top.getParent() != null)
			top = top.getParent();

		showGroupInfo("    ",top);
	}

	
	public static void showGroupInfo(String indent, ThreadGroup group) {
		if (group==null) return;
		Thread[] threads = new Thread[group.activeCount()];

		group.enumerate(threads, false);
		System.out.println(indent + group);

		for (Thread t : threads)
			if (t != null)
				System.out.printf("%s%s -> %s is %sDaemon%n",indent ,group.getName(), t,
						t.isDaemon() ? "" : "no ");

		ThreadGroup[] activeGroup = new ThreadGroup[group.activeGroupCount()];
		group.enumerate(activeGroup, false);
		for (ThreadGroup g : activeGroup)
			showGroupInfo(indent+indent, g);
	}
}
