package sleepingbarber;

/**
 * Der SleepingBarber. Er schlaeft (so gut we) immer und wird zwischendurch geweckt um seine Arbeit zu erledigen.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 14.05.2007
 */
public class SleepingBarber extends Thread {

	private Customer kunde;
	
	/**
	 * Einen SleepingBarber erzeugen
	 * @param name Name des Barber
	 */
	public SleepingBarber(String name) {
		setName(name);
		kunde = null;
	}

	/**
	 * BarberThread
	 */
	public void run() {
		while (true) {	// Lebe ewig
			try {
									// Wenn unwahrscheinlicherweise zwischen zwei sleeps geweckt
				if(interrupted()) { // interrupted()  setzt den Status wieder zurueck
					cutHair();		// Haare schneiden falls geweckt
					
				}
				sleep(Long.MAX_VALUE);	// Schlafe moeglichst lang
			} catch (InterruptedException e) {	// Falls waehrend des sleep geweckt
				System.out.printf("%s: Wer Weckt mich da? Dann muss ich wohl arbeiten.%n",getName());
				cutHair();				// Haare schneiden
			}
		}
	}

	/**
	 * Weckt den Barber. Der Customer wird mit uebergeben.
	 * @param c
	 */
	public synchronized void wakeUp(Customer c) {
		kunde = c;
		interrupt();
	}
	
	/**
	 * Haare schneiden
	 */
	private void cutHair() {
		int zeit = (int) (Math.random() * 5000);
		
		if (kunde!=null) {
			try {
				sleep(zeit);
			} catch (InterruptedException e) {
			}
			System.out.printf("Barber hat dem Kunden %s in %dms die Haare geschnitten.%n",kunde.getName(), zeit);
			kunde.hairCutted();
			kunde=null;
		}
	}
}