package sleepingbarber;

import java.util.TimerTask;

/**
 * Informationen ueber die Kunden wiederholt ausgeben.
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 09.05.2007
 */
public class CustomerPrintTask extends TimerTask {

	private Customer[] customers;
	
	public CustomerPrintTask(Customer ... customers) {
		this.customers = customers;
	}
	
	public void run() {
		StringBuilder sb = new StringBuilder();
		for(Customer c: customers) {
			sb.append(c).append("\t");
		}
		System.out.println(sb);
	}
}
