package semaphore1;

import java.util.concurrent.Semaphore;

/**
 * Demonstration eines Semaphore.
 * 
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 06.05.2007
 */
public class DataObject {
	private final Semaphore SEMAPHORE = new Semaphore(3);

	public void manipulateData() {
		
		try {
			SEMAPHORE.acquire();
			System.out.println(Thread.currentThread().getName() + " manipuliert die Daten.");
			System.out.println("    Es sind noch " + SEMAPHORE.availablePermits() + " frei");
			Thread.sleep(200);
		} catch (InterruptedException e) {
			System.err.println("Wärend des Wartens geweckt worden ...");
		} finally {
			SEMAPHORE.release();
		}
	}
}
