package diningphilosophers2;

import java.util.TimerTask;

/**
 * Thread der Informationen zu Philosopher-Objekten ausgibt.
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 10.05.2007
 */
public class PrintPhilosophersInformation extends TimerTask {

	Philosopher[] philosophers;
	public PrintPhilosophersInformation(Philosopher[] philosophers) {
		this.philosophers = philosophers;
	}
	
	/* (non-Javadoc)
	 * @see java.util.TimerTask#run()
	 */
	@Override
	public void run() {
		StringBuilder sb = new StringBuilder();
		for(Philosopher p:philosophers)
			sb.append(p).append("  |  ");
		sb.append("\n");
		System.out.println(sb);

	}

}
