package diningphilosophers2;

/**
 * Klasse ChopStick, die ein Essstaebchen repraesentiert.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 14.05.2007
 */
public class ChopStick {

	private boolean taken = false;

	private String name;

	/**
	 * Erzeugt ein ChopStick
	 * 
	 * @param name Name des ChopStick
	 */
	public ChopStick(String name) {
		this.name = name;
	}

	/**
	 * ChopStick ablegen. Alle Threads die auf dieses Objekt warten werden geweckt.
	 */
	synchronized void put() {
		taken = false;
		notifyAll();
	}

	/**
	 * ChopStick aufnehmen. Falls es nicht verfuegbar ist wird gewartet.
	 * @throws java.lang.InterruptedException
	 */
	synchronized void get() throws java.lang.InterruptedException {
		while (taken)
			wait();
		taken = true;

	}
	
	public String toString() {
		return name;
	}
}
