package diningphilosophers1;

/**
 * Ein Philosoph, der eine bestimmte Zeit denkt, danach essen moechte.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 14.05.2007
 */
public class Philosopher extends Thread {
	private ChopStick left;

	private ChopStick right;

	/**
	 * Konstruktor, der einen Philosophen erstellt und mit ChopSticks versieht.
	 * @param name Name des Philosophen
	 * @param l linkes Essstaebchen
	 * @param r rechtes Essstaebchen
	 */
	public Philosopher(String name, ChopStick l, ChopStick r) {
		setName(name);
		left = l;
		right = r;
	}

	/**
	 * Ausfuehrung des Threads
	 */
	public void run() {
		try {
			while (true) { // Lebe unendlich
				// thinking
				System.out.printf("%s denkt nach.%n",getName());
				sleep((int)(Math.random()*1000));
				// hungry
				System.out.printf("%s ist hungrig.%n",getName());
				right.get();
				// gotright chopstick
				System.out.printf("%s hat das rechte Staebchen.%n",getName());
				sleep(500);
				left.get();
				// eating
				System.out.printf("%s hat das linke Staebchen und isst.%n",getName());
				sleep((int)(Math.random()*1000));
				right.put();
				left.put();
			}
		} catch (java.lang.InterruptedException e) {
			System.err.printf("%s wurde geweckt, das sollte nicht so sein.",getName());
		}
	}
	
	public String toString() {
		return left + " " + getName() + " " + right;
	}
}
