package synchronize3;

/**
 * Verschiedene Arten der Synchronisation.
 *  
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 08.05.2007
 */
public class KlassenSynchronisiert {
	private final Object MYMONITOR = new Object();

	private Object[] array;

	public KlassenSynchronisiert(Object[] o) {
		array = new Object[o.length];
		System.arraycopy(o, 0, array, 0, o.length);
	}

	public void swap(int index1, int index2) {
		// In diesem Moment sind ALLE Blöcke gesperrt, die auch
		// auf Object.class synchronisieren
		// Dies funktioniert aber nur, da das Array private ist und kein
		// anderer darauf Zugriff hat
		synchronized (Object.class) {
			Object tmp = array[index1];
			array[index1] = array[index2];
			array[index2] = tmp;

		}
	}

	public void swap2(int index1, int index2) {
		synchronized (KlassenSynchronisiert.class) {
			// In diesem Moment sind ALLE Blöcke gesperrt, die auch
			// auf KlassenSynchronisiert.class synchronisieren
			// Dies funktioniert aber nur, da das Array private ist und kein
			// anderer darauf Zugriff hat
			Object tmp = array[index1];
			array[index1] = array[index2];
			array[index2] = tmp;
		}
	}

	public void swap3(int index1, int index2) {
		synchronized (MYMONITOR) {
			// In diesem Moment sind ALLE Blöcke gesperrt, die auch
			// auf MYMONITOR synchronisieren
			// Dies funktioniert aber nur, da das Array private ist und kein
			// anderer darauf Zugriff hat
			Object tmp = array[index1];
			array[index1] = array[index2];
			array[index2] = tmp;
		}
	}

	public void swap4(int index1, int index2) {
		synchronized (array) {
			// In diesem Moment sind ALLE Blöcke gesperrt, die auch
			// auf array synchronisieren
			// In diesem Falle sehr sinnvoll, da dies Objekt auch manipuliert
			// wird
			Object tmp = array[index1];
			array[index1] = array[index2];
			array[index2] = tmp;
		}
	}
}
