package deadlock1;

/**
 * Thread, der schreiben moechte und dafuer Stift und Papier benoetigt.
 * Wichtig: Er benoetigt die Ressource nur fuer sich, muss also synchronisieren.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 05.05.2007
 */
public class Thread2 extends Thread {
	
	private SchreibUtensilien su;
	
	public Thread2(String name, SchreibUtensilien su) {
		setName(name);
		this.su = su;
	}
	
	public void run() {
		synchronized(su.getStift()) {
			System.out.println(getName() + " hat den Stift und wartet auf das Papier");
			
			synchronized (su.getPapier()) {
				System.out.println("Ich (" + getName() + ") schreibe");
			}
		}
	}
}
