package cast2;

/**
 * Klasse repräsentiert eine Person.
 * @author Ralf Kunze, Institut fuer Informatik, Universitaet Osnabrueck
 * @version 04/2007
 */
public class Person {
	/**
	 * Name der Person
	 */
	private String name;
	
	/**
	 * Default Constructor, setzt den Namen auf <tt>NA</tt>.
	 */
	public Person() {
		this("NA");
	}
	
	/**
	 * Custom Constructor.
	 * @param name Name der Person
	 */	
	public Person(String name) {
		setName(name);
	}
	
	/**
	 * Liefert den Namen der Person zurück.
	 * @return Name der Person
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * Setzt den Namen einer Person.
	 * @param name Neuer Name der Person
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * Ueberschriebene Methode.
	 * @return Beschreibung der Person
	 */
	public String toString() {
		return "Person mit Namen: "+ name;
	}
}
