package abstrakt1;

/**
 * Abstrakte Klasse Person, die als Eigenschaft einen Namen besitzt.
 * 
 * @author Ralf Kunze, Institut fuer Informatik, Universitaet Osnabrueck
 * @version 04/2007
 */
public abstract class Person {
	private String name;

	/**
	 * Custom Constructor
	 * @param name Name der Person
	 */
	public Person(String name) {
		this.name = name;
	}
	
	/**
	 * Liefert den Namen der Person
	 * @return Name der Person
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * Setzt den Namen der Person neu, ohne weitere Pruefung
	 * @param name Neuer Name
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * Liefert die Taetigkeit eines Objektes der Subclasse
	 * @return Taeteigkeitsbeschreibung
	 */
	public abstract String getTaetigkeit();
}
