package gameapi3;

import java.io.IOException;

import javax.microedition.lcdui.*;
import javax.microedition.lcdui.game.*;

public class SimpleGameCanvas extends GameCanvas implements Runnable {
    private volatile boolean running;

    private long ticksTillNewFrame;

    private int mX, mY;

    private int actuelTicks;

    private Image image;
    
    private Image image2;
    
    private TiledLayer tiledLayer;
    
    private Sprite sprite;
    
    public SimpleGameCanvas() {
        super(true);
        mX = getWidth() / 2;
        mY = getHeight() / 2;
        actuelTicks = 0;
        ticksTillNewFrame = 20;
        
        try {
            image = Image.createImage("/pics/background.png");
            tiledLayer = new TiledLayer(10, 10, image, 32, 35);
            System.out.println("Zerlegt");
            
            int[] map = {
                    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
                    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
                    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
                    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
                    0,  0,  0,  0,  8,  0,  0,  0,  0,  0,
                    0,  0,  0,  0,  1,  2,  3,  0,  0,  0,
                    0,  0,  0,  1,  4,  4,  4,  3,  0,  0,
                    0,  0,  1,  4,  4,  4,  4,  4,  3,  0,
                    0,  1,  4,  4,  4,  4,  4,  4,  4,  3,
                    5,  6,  7,  7,  6,  5,  6,  5,  6,  7
                 };
                 
                 for (int i = 0; i < map.length; i++) {
                   int column = i % 10;
                   int row = (i - column) / 10;
                   tiledLayer.setCell(column, row, map[i]);
                 }
                 
                 
                 image2 = Image.createImage("/pics/fliege.png");
                 sprite = new Sprite(image2, 96, 38);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void start() {
        running = true;
        Thread t = new Thread(this);
        t.start();
    }

    public void stop() {
        running = false;
    }

    public void run() {
        Graphics g = getGraphics();

        while (running == true) {
            tick();
            input();
            render(g);
            try {
                Thread.sleep(ticksTillNewFrame);
            } catch (InterruptedException ie) {
                stop();
            }
        }
    }

    private void tick() {
        actuelTicks = (actuelTicks + 1) % 20;
    }

    private void input() {
        int keyStates = getKeyStates();
        if ((keyStates & LEFT_PRESSED) != 0)
            mX = Math.max(0, mX - 1);
        if ((keyStates & RIGHT_PRESSED) != 0)
            mX = Math.min(getWidth(), mX + 1);
        if ((keyStates & UP_PRESSED) != 0)
            mY = Math.max(0, mY - 1);
        if ((keyStates & DOWN_PRESSED) != 0)
            mY = Math.min(getHeight(), mY + 1);
        
    }

    private void render(Graphics g) {
        
        
        g.setColor(0xffffff);
        g.fillRect(0, 0, getWidth(), getHeight());


        tiledLayer.paint(g);
        
        sprite.setPosition(mX, mY);
        sprite.paint(g);
        sprite.nextFrame();
        if(sprite.getFrame()==3)
            sprite.nextFrame();
        
        flushGraphics();
    }
}
