package gameapi1;

import javax.microedition.lcdui.*;
import javax.microedition.lcdui.game.*;

public class SimpleGameCanvas extends GameCanvas implements Runnable {
    
    private volatile boolean running;

    private long ticksTillNewFrame;

    private int mX, mY;

    private int actualTicks;

    public SimpleGameCanvas() {
        super(true);
        mX = getWidth() / 2;
        mY = getHeight() / 2;
        actualTicks = 0;
        ticksTillNewFrame = 20;
    }

    public void start() {
        running = true;
        Thread t = new Thread(this);
        t.start();
    }

    public void stop() {
        running = false;
    }

    public void run() {
        Graphics g = getGraphics();

        while (running == true) {
            tick();
            input();
            render(g);
            try {
                Thread.sleep(ticksTillNewFrame);
            } catch (InterruptedException ie) {
                stop();
            }
        }
    }

    private void tick() {
        actualTicks = (actualTicks + 1) % 20;
    }

    private void input() {
        int keyStates = getKeyStates();
        if ((keyStates & LEFT_PRESSED) != 0)
            mX = Math.max(0, mX - 1);
        if ((keyStates & RIGHT_PRESSED) != 0)
            mX = Math.min(getWidth(), mX + 1);
        if ((keyStates & UP_PRESSED) != 0)
            mY = Math.max(0, mY - 1);
        if ((keyStates & DOWN_PRESSED) != 0)
            mY = Math.min(getHeight(), mY + 1);
    }

    private void render(Graphics g) {
        g.setColor(0xffffff);
        g.fillRect(0, 0, getWidth(), getHeight());

        g.setColor(0x0000ff);
        g.drawLine(mX, mY, mX - 10 + actualTicks, mY - 10);
        g.drawLine(mX, mY, mX + 10, mY - 10 + actualTicks);
        g.drawLine(mX, mY, mX + 10 - actualTicks, mY + 10);
        g.drawLine(mX, mY, mX - 10, mY + 10 - actualTicks);

        flushGraphics();
    }
}
