package einkaufsliste5;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/**
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 30.06.2007
 */
public class Artikel {
    private String name;
    private boolean selected;
    
    public Artikel(boolean selected, String name) {
        this.name = name;
        this.selected = selected;
    }
    
    public Artikel(String name) {
        selected = false;
        this.name = name;
    }
    
    public Artikel() {
        this(false, "");
    }
    
    public String getName() {
        return name;
    }
    
    public boolean isSelected() {
        return selected;
    }
    
    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        
        dos.writeUTF(name);
        dos.writeBoolean(selected);
        
        dos.close();
        
        return baos.toByteArray();
    }
    
    public void setBytes(byte[] record) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(record);
        DataInputStream dis = new DataInputStream(bais);
        
        name = dis.readUTF();
        selected = dis.readBoolean();
        
        dis.close();
    }
}
