package einkaufsliste3;

import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class EinkaufsListeUI extends MIDlet {

    private List dispList;
    private Display display;
    private Command exitCom;
    private Command insertCom;
    private Form newArticleForm;
    
    public EinkaufsListeUI() {
        dispList = new List("Einkaufsliste", Choice.MULTIPLE);
        
        dispList.append("Bier", null);
        dispList.append("Brot", null);
        dispList.append("Datteln", null);
        dispList.append("Eier", null);
        dispList.append("Fisch", null);
        dispList.append("Zucker", null);
        
        newArticleForm = createNewArticleForm();
        
        exitCom = new Command("Exit", Command.EXIT, 1);
        dispList.addCommand(exitCom);
    
        insertCom = new Command("Insert", Command.SCREEN, 1);
        dispList.addCommand(insertCom);
        
        dispList.setCommandListener(new CommandListener() {
            public void commandAction(Command c, Displayable d) {
                if (c == exitCom) {
                    try {
                        destroyApp(false);
                        notifyDestroyed();
                    } catch (MIDletStateChangeException e) {
                        e.printStackTrace();
                    }
                } else if(c == insertCom) {
                    display.setCurrent(newArticleForm);
                }
            }
        });
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        // TODO Auto-generated method stub

    }

    protected void pauseApp() {
        // TODO Auto-generated method stub

    }

    protected void startApp() throws MIDletStateChangeException {
        if(display == null) {
            display = Display.getDisplay(this);
            display.setCurrent(dispList);
        }
    }

    private Form createNewArticleForm() {
        final Form form = new Form("Neuer Artikel");
        final TextField textEingabe = new TextField("Neuer Eintrag:", null, 40, TextField.ANY);
        form.append(textEingabe);
        
        final Command okCom = new Command("OK", Command.OK, 1);
        final Command cancelCom = new Command("Cancel", Command.CANCEL, 2);
        
        form.addCommand(okCom);
        form.addCommand(cancelCom);
        
        form.setCommandListener(new CommandListener() {
            public void commandAction(Command c, Displayable d) {
                if(c == okCom) {
                    insertArticle(textEingabe.getString());
                    textEingabe.setString("");
                    display.setCurrent(dispList);
                } else if(c == cancelCom) {
                    textEingabe.setString("");
                    display.setCurrent(dispList);
                }
            }
            
        });
        return form;
    }
    
    private void insertArticle(String s) {
        if(s != null && s.compareTo("")!=0) {
            int index = 0;
            while (index < dispList.size()
                    && s.toLowerCase().compareTo(dispList.getString(index).toLowerCase()) > 0) {
                index++;
            }
            dispList.insert(index, s, null);
        }
    }
}
