/*
 * Decompiled with CFR 0.152.
 */
package einkaufsliste2;

import einkaufsliste1.Artikel;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class EinkaufsListeUI
extends MIDlet {
    private Display display = null;
    private List dispList = new List("Einkaufsliste", 2);
    private List deleteList;
    private Command exitCom;
    private Command addCom;
    private TextField text;
    private Form form;
    private Command okCom;
    private Command cancelCom;
    private Command delCom;
    private Command deselectAllCom;
    private RecordStore store;
    final String RECORD_NAME;

    public EinkaufsListeUI() {
        this.RECORD_NAME = "EINKAUFSLISTE";
        try {
            this.store = RecordStore.openRecordStore((String)"EINKAUFSLISTE", (boolean)true, (int)0, (boolean)true);
            RecordEnumeration enumerator = this.store.enumerateRecords(null, null, false);
            if (enumerator.numRecords() == 0) {
                this.createNewList();
            } else {
                this.loadList();
            }
        }
        catch (Exception e1) {
            this.alert("Konstruktor: Daten k\u00f6nnen nicht gespeichert werden!", e1);
        }
        this.form = new Form("Eingabeformular");
        this.text = new TextField("Neuer Eintrag:", null, 40, 0);
        this.okCom = new Command("OK", 4, 1);
        this.cancelCom = new Command("Cancel", 3, 2);
        this.text.addCommand(this.okCom);
        this.text.addCommand(this.cancelCom);
        this.text.setItemCommandListener(new ItemCommandListener(){

            public void commandAction(Command c, Item i) {
                if (c == EinkaufsListeUI.this.okCom) {
                    Artikel item = new Artikel(EinkaufsListeUI.this.text.getString());
                    int index = 0;
                    while (index < EinkaufsListeUI.this.dispList.size() && item.getName().toLowerCase().compareTo(EinkaufsListeUI.this.dispList.getString(index).toLowerCase()) > 0) {
                        ++index;
                    }
                    EinkaufsListeUI.this.dispList.insert(index, item.getName(), null);
                    try {
                        EinkaufsListeUI.this.storeList();
                    }
                    catch (Exception e) {
                        EinkaufsListeUI.this.alert("insertCommand: Daten k\u00f6nnen nicht gespeichert werden!", e);
                    }
                }
                EinkaufsListeUI.this.text.setString("");
                EinkaufsListeUI.this.display.setCurrent((Displayable)EinkaufsListeUI.this.dispList);
            }
        });
        this.form.append((Item)this.text);
        this.form.setTicker(new Ticker("Geben Sie einen neuen Artikel ein"));
        this.display = Display.getDisplay((MIDlet)this);
        this.exitCom = new Command("Exit", 7, 1);
        this.dispList.addCommand(this.exitCom);
        this.addCom = new Command("AddItem", 1, 1);
        this.dispList.addCommand(this.addCom);
        this.delCom = new Command("Eintr\u00e4ge l\u00f6schen", 1, 2);
        this.dispList.addCommand(this.delCom);
        this.deselectAllCom = new Command("Alles deselectieren", 1, 3);
        this.dispList.addCommand(this.deselectAllCom);
        this.dispList.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c == EinkaufsListeUI.this.exitCom) {
                    try {
                        EinkaufsListeUI.this.destroyApp(false);
                        EinkaufsListeUI.this.notifyDestroyed();
                    }
                    catch (MIDletStateChangeException e) {
                        e.printStackTrace();
                    }
                } else if (c == EinkaufsListeUI.this.addCom) {
                    EinkaufsListeUI.this.display.setCurrent((Displayable)EinkaufsListeUI.this.form);
                } else if (c == EinkaufsListeUI.this.delCom) {
                    EinkaufsListeUI.this.deleteItem();
                } else if (c == EinkaufsListeUI.this.deselectAllCom) {
                    boolean[] falseFlags = new boolean[EinkaufsListeUI.this.dispList.size()];
                    EinkaufsListeUI.this.dispList.setSelectedFlags(falseFlags);
                }
            }
        });
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        try {
            this.storeList();
            this.store.closeRecordStore();
        }
        catch (Exception e) {
            this.alert("destroyApp: Speichern fehlgeschlagen", e);
        }
    }

    protected void pauseApp() {
    }

    protected void startApp() throws MIDletStateChangeException {
        this.display.setCurrent((Displayable)this.dispList);
    }

    private void loadList() throws RecordStoreException, IOException {
        int i = 1;
        while (i <= this.store.getNumRecords()) {
            byte[] record = this.store.getRecord(i);
            Artikel a = new Artikel();
            a.setBytes(record);
            if (a.getName().compareTo("") != 0) {
                this.dispList.append(a.getName(), null);
                this.dispList.setSelectedIndex(i - 1, a.isSelected());
            }
            ++i;
        }
    }

    private void storeList() throws RecordStoreException, IOException {
        int entries = this.dispList.size();
        boolean[] flags = new boolean[entries];
        this.dispList.getSelectedFlags(flags);
        int i = 0;
        while (i < entries) {
            Artikel a = new Artikel(flags[i], this.dispList.getString(i));
            byte[] record = a.getBytes();
            if (i + 1 <= this.store.getNumRecords()) {
                this.store.setRecord(i + 1, record, 0, record.length);
            } else {
                this.store.addRecord(record, 0, record.length);
            }
            ++i;
        }
        byte[] dummyRecord = new Artikel().getBytes();
        int i2 = entries + 1;
        while (i2 <= this.store.getNumRecords()) {
            this.store.setRecord(i2, dummyRecord, 0, dummyRecord.length);
            ++i2;
        }
    }

    private void createNewList() throws IOException, RecordStoreException {
        Artikel a = new Artikel("Bier");
        byte[] record = a.getBytes();
        this.store.addRecord(record, 0, record.length);
        this.dispList.append(a.getName(), null);
        a = new Artikel("Butter");
        record = a.getBytes();
        this.store.addRecord(record, 0, record.length);
        this.dispList.append(a.getName(), null);
        a = new Artikel("K\u00e4se");
        record = a.getBytes();
        this.store.addRecord(record, 0, record.length);
        this.dispList.append(a.getName(), null);
        a = new Artikel("Wasser");
        record = a.getBytes();
        this.store.addRecord(record, 0, record.length);
        this.dispList.append(a.getName(), null);
        a = new Artikel("Wurst");
        record = a.getBytes();
        this.store.addRecord(record, 0, record.length);
        this.dispList.append(a.getName(), null);
        a = new Artikel("Zucker");
        record = a.getBytes();
        this.store.addRecord(record, 0, record.length);
        this.dispList.append(a.getName(), null);
    }

    private void alert(String msg, Exception e) {
        Alert alert = new Alert("Fehler", msg, null, AlertType.ERROR);
        alert.setTimeout(2000);
        this.display.setCurrent((Displayable)alert);
        System.out.println(String.valueOf(msg) + e);
    }

    private void deleteItem() {
        this.deleteList = new List("Elemente l\u00f6schen", 2);
        this.deleteList.setTicker(new Ticker("W\u00e4hlen Sie Elemente zum l\u00f6schen aus"));
        int i = 0;
        while (i < this.dispList.size()) {
            this.deleteList.append(this.dispList.getString(i), null);
            ++i;
        }
        final Command delCom = new Command("L\u00f6schen", 1, 1);
        final Command backCom = new Command("Zur\u00fcck", 2, 1);
        this.deleteList.addCommand(delCom);
        this.deleteList.addCommand(backCom);
        this.deleteList.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c == delCom) {
                    boolean[] flags = new boolean[EinkaufsListeUI.this.deleteList.size()];
                    EinkaufsListeUI.this.deleteList.getSelectedFlags(flags);
                    int i = EinkaufsListeUI.this.deleteList.size() - 1;
                    while (i >= 0) {
                        if (flags[i]) {
                            EinkaufsListeUI.this.dispList.delete(i);
                        }
                        --i;
                    }
                    try {
                        EinkaufsListeUI.this.storeList();
                    }
                    catch (Exception e) {
                        EinkaufsListeUI.this.alert("deleteItem: Speichern nicht m\u00f6glich", e);
                    }
                    EinkaufsListeUI.this.display.setCurrent((Displayable)EinkaufsListeUI.this.dispList);
                } else if (c == backCom) {
                    EinkaufsListeUI.this.display.setCurrent((Displayable)EinkaufsListeUI.this.dispList);
                }
            }
        });
        this.display.setCurrent((Displayable)this.deleteList);
    }

    static /* synthetic */ Command access$5(EinkaufsListeUI einkaufsListeUI) {
        return einkaufsListeUI.cancelCom;
    }
}

