package swing7;

import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.UIManager.LookAndFeelInfo;

public class UITest {
    public static void main(String[] args) {
        final JFrame f = new JFrame("UITest");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        
        String[] lafStrings = new String[lafs.length];
        for (int i = 0; i < lafs.length; i++) {
            lafStrings[i] = lafs[i].getClassName();
        }
        
        JComboBox comboBox = new JComboBox(lafStrings);
        comboBox.addItemListener(new ItemListener() {

            public void itemStateChanged(ItemEvent e) {
                String choice = (String) e.getItem();
                try {
                    UIManager.setLookAndFeel(choice);
                } catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                } catch (InstantiationException e1) {
                    e1.printStackTrace();
                } catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                } catch (UnsupportedLookAndFeelException e1) {
                    e1.printStackTrace();
                }
                SwingUtilities.updateComponentTreeUI(f);
            }

        });

        f.add(comboBox, BorderLayout.PAGE_END);

        f.add(new JButton("Klick"), BorderLayout.NORTH);

        final JProgressBar progressBar = new JProgressBar();
        progressBar.setOrientation(JProgressBar.HORIZONTAL);
        progressBar.setMaximum(100);
        progressBar.setMinimum(1);
        progressBar.setValue(33);
        progressBar.setToolTipText("JProgressBar: Fortschrittsbalken");
        progressBar.setBorder(BorderFactory
                .createTitledBorder("JProgressBar: Fortschrittsbalken"));
        progressBar.addMouseWheelListener(new MouseWheelListener() {
            public void mouseWheelMoved(MouseWheelEvent e){
                int value = progressBar.getValue();
                progressBar.setValue(e.getWheelRotation()+value);
            }
        });
        f.add(progressBar,BorderLayout.CENTER);
        
        JCheckBox cb1 = new JCheckBox("Informatik A", true);
        f.add(cb1, BorderLayout.EAST);
        
        f.add(new JLabel("<html><h1 color=green>Hallo</h1></html>"),BorderLayout.WEST);
        
        f.setLocation(200, 200);
        f.pack();
        f.setVisible(true);
    }
}
