package swing6;

import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;

public class CheckBoxDemo {
    
    public static void main(String[] args) {
        JFrame f = new JFrame("Vorlesungsauswahl");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        Icon unchecked = new ImageIcon(CheckBoxDemo.class
                .getResource("pics/cancel.png"));
        Icon checked = new ImageIcon(CheckBoxDemo.class
                .getResource("pics/ok.png"));

        JCheckBox cb1 = new JCheckBox("Informatik A", true);
        cb1.setIcon(unchecked);
        cb1.setSelectedIcon(checked);
        f.add(cb1, BorderLayout.PAGE_START);

        JCheckBox cb2 = new JCheckBox("Informatik B", false);
        cb2.setIcon(unchecked);
        cb2.setSelectedIcon(checked);
        f.add(cb2, BorderLayout.PAGE_END);

        ItemListener vorlesungsListener = new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == ItemEvent.DESELECTED)
                    System.out.println("Abgewählt");
                else
                    System.out.println("Gewählt");
            }
        };

        cb1.addItemListener(vorlesungsListener);
        cb2.addItemListener(vorlesungsListener);

        f.pack();
        f.setVisible(true);
    }
}
