package swing5;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URISyntaxException;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TabbedPaneDemo {
    
    public JPanel createGUI() {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(1, 1));
        
        JTabbedPane tabbedPane = new JTabbedPane();
        ImageIcon hundIcon = createImageIcon("pics/hund.gif");
        ImageIcon katzeIcon = createImageIcon("pics/katze.gif");
        
        JComponent panel1 = makeImagePanel("pics/oliver.jpg");
        tabbedPane.addTab("Tab 1", hundIcon, panel1,"Bild von Oliver");
        tabbedPane.setMnemonicAt(0, KeyEvent.VK_1);
        
        JComponent panel2 = makeImagePanel("pics/dorothee.jpg");
        tabbedPane.addTab("Tab 2", katzeIcon, panel2,"Bild von Dorothee");
        tabbedPane.setMnemonicAt(1, KeyEvent.VK_2);
        
        JComponent panel3 = makeImagePanel("pics/pfox.jpg");
        tabbedPane.addTab("Tab 3", hundIcon, panel3,"Bild von Patrick");
        tabbedPane.setMnemonicAt(2, KeyEvent.VK_3);
        
        JComponent panel4 = makeImagePanel("pics/ralf.jpg");
        tabbedPane.addTab("Tab 4", katzeIcon, panel4,"Bild von Ralf");
        tabbedPane.setMnemonicAt(3, KeyEvent.VK_4);
        
        tabbedPane.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
        
        p.add(tabbedPane);
        
        return p;
    }
    
    protected JComponent makeImagePanel(String fileName) {
        JPanel panel = new JPanel();
        try {
            panel.add(new MyImageCanvas(TabbedPaneDemo.class.getResource(fileName)));
        } catch (IOException e) {
            e.printStackTrace();
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return panel;
    }
    
    protected static ImageIcon createImageIcon(String path) {
        java.net.URL imgURL = TabbedPaneDemo.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        } else {
            System.err.println("Couldn't find file: " + path);
            return null;
        }
    }
    
    public static void main(String[] args) {
        JFrame frame = new JFrame("TabbedPaneDemo");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        frame.add(new TabbedPaneDemo().createGUI(), BorderLayout.CENTER);
        
        frame.pack();
        frame.setVisible(true);
    }
}
