package swing5;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;

import javax.imageio.ImageIO;
import javax.swing.JViewport;

/**
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 22.06.2007
 */
@SuppressWarnings("serial")
public class MyImageCanvas extends JViewport {

    BufferedImage image;

    public MyImageCanvas(URL url) throws IOException, URISyntaxException {
        this(url.openStream());
    }

    
    public MyImageCanvas(String filename) throws IOException {
        image = ImageIO.read(new File(filename));
        setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        repaint();
    }

    public MyImageCanvas(InputStream input) throws IOException {
        image = ImageIO.read(input);
        setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        repaint();
    }

    public void paint(Graphics g) {
        if (image != null)
            g.drawImage(image, 0, 0, this);
    }
}
