package swing4;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.IOException;

import javax.swing.JFrame;
import javax.swing.JScrollPane;

/**
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 25.06.2007
 */
public class ContainerTest {

    /**
     * @param args
     */
    public static void main(String[] args) {
        JFrame f = new JFrame("Container Test");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setLayout(new FlowLayout());
        
        JScrollPane scrollPane = null;
        try {
            MyImageCanvas mic = new MyImageCanvas(ContainerTest.class.getResourceAsStream("pics/GoogleEarthWetter.jpg"));
            scrollPane = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
            scrollPane.getViewport().add(mic);
        } catch (IOException e) {
            e.printStackTrace();
        }
        
        scrollPane.setPreferredSize(new Dimension(400,200));
        f.add(scrollPane);
        
        f.pack();
        f.setVisible(true);
    }

}
