package swing3;

import java.awt.FlowLayout;
import java.net.URL;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.BevelBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;

import swing2.GUITest;


/**
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 25.06.2007
 */
public class BorderDemo {

    public static void main(String[] args) {
        JFrame f = new JFrame("GUI-Test");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setLayout(new FlowLayout());

        
        
        JLabel label1 = new JLabel("Eingelassenner Rahmen");
        label1.setToolTipText("Ein Label mit vertieften Rahmen");
        label1.setBorder(new BevelBorder(BevelBorder.LOWERED));
        f.add(label1);
        
//        JLabel label2 = new JLabel("Hervorgehobener Rahmen");
//        label2.setToolTipText("Ein Label mit hervorgehobener Rahmen");
//        label2.setBorder(new BevelBorder(BevelBorder.RAISED));
//        f.add(label2);
//        
//        JLabel label3 = new JLabel("Rahmen mit Titel");
//        label3.setToolTipText("Ein Label mit Titelrahmen");
//        label3.setBorder(new TitledBorder("Titel"));
//        f.add(label3);
//        
//        Icon icon1 = createImageIcon("pics/java.jpg"," Ein kleines Javabildchen");
//        
//        JLabel label4 = new JLabel("Rahmen mit Icon Rahmen");
//        label4.setToolTipText("Ein Label mit Iconrahmen");
//        label4.setBorder(new MatteBorder(icon1));
//        f.add(label4);
        
        f.pack();
        f.setVisible(true);
    }

    protected static ImageIcon createImageIcon(String path, String description) {
        URL imgURL = GUITest.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        } else {
            System.err.println("Couldn't find file: " + path);
            return null;
        }
    }
}
