package swing2;

import java.awt.FlowLayout;
import java.net.URL;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JToggleButton;

/**
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 25.06.2007
 */
public class GUITest {
    public static void main(String[] args) {
        JFrame f = new JFrame("GUI-Test");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setLayout(new FlowLayout());

        Icon icon = createImageIcon("pics/java.jpg", " Ein kleines Javabildchen");
        JLabel label1 = new JLabel("Java-Programmieren ist toll", icon, JLabel.RIGHT);
        label1.setVerticalTextPosition(JLabel.BOTTOM);
        label1.setHorizontalTextPosition(JLabel.CENTER);
        label1.setToolTipText("Ein Label mit Bild");
        f.add(label1);

//        JLabel label2 = new JLabel("<html><h1>Hallo Binfler</h1><br>Viel Spass in der Vorlesung!</html>");
//        label2.setToolTipText("Label mit HTML");
//        f.add(label2);
//        
//        JButton button1 = new JButton("Click Me!!", icon);
//        button1.setVerticalTextPosition(JButton.CENTER);
//        button1.setHorizontalTextPosition(JButton.CENTER);
//        button1.setToolTipText("Button mit Bild");
//        f.add(button1);
//        
//        JToggleButton button2 = new JToggleButton("Toggle Me!!", icon);
//        button2.setVerticalTextPosition(JButton.CENTER);
//        button2.setHorizontalTextPosition(JButton.CENTER);
//        button2.setToolTipText("JToggleButton mit Bild");
//        f.add(button2);
//        
//        f.add(new JButton("<html><p>1<sup>st</sup></p></html>"));
//        f.add(new JButton("<html><p>2<sup>st</sup></p></html>"));
//        
//        f.add(new JButton("<html><h1>3<sup>rd</sup></h1><hr><p color=green> Use <u>Green</u></p></html>"));
        
        f.pack();
        f.setVisible(true);
    }

    protected static ImageIcon createImageIcon(String path, String description) {
        URL imgURL = GUITest.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        } else {
            System.err.println("Couldn't find file: " + path);
            return null;
        }
    }
}
