package mvc1;

import java.util.LinkedList;
import java.util.List;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 25.06.2007
 */
public class Modell {
    private double value;
    
    List<ChangeListener> clList;
    
    public Modell(double value) {
        this.value = value;
        clList = new LinkedList<ChangeListener>();
    }
    
    public double getValue() {
        return value;
    }
    
    public void addValue(double delta) {
        value+=delta;
        for(ChangeListener cl: clList) {
            cl.stateChanged(new ChangeEvent(this));
        }
    }
    
    public void addChangeListener(ChangeListener c) {
        clList.add(c);
    }
}
