package mvc1;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;

/**
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 25.06.2007
 */
@SuppressWarnings("serial")
public class KontoViewCanvas extends Canvas implements KontoView {

    private int height;
    private int width;
    double value;
    
    public KontoViewCanvas(double value, int height, int width) {
        super();
        this.setSize(width, height);
        this.value = value;
    }
    
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        super.setSize(width,height);
    }
    
    public void paint(Graphics g) {
        g.setColor(new Color(255,0,120));
        g.fill3DRect(width/3, height-(int)value, width/3, (int)value, true);
    }
    
    public void setValue(double value) {
        this.value = value;
        repaint();
    }
}
