/**
 * 
 */
package mvc1;

import java.awt.GridLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.LinkedList;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 25.06.2007
 */
public class Controller implements ChangeListener {

    private List<KontoView> views;
    
    public Controller(double value) {
        views = new LinkedList<KontoView>();
    }
    
    public void stateChanged(ChangeEvent e) {
        Object o = e.getSource();
        if(o instanceof Modell) {
            double value = ((Modell)o).getValue();
            for(KontoView kv: views) {
                kv.setValue(value);
            }
        }
    }
    
    public void addView(KontoView kv) {
        views.add(kv);
    }
    
    public static void main(String[] args) {
        final double INITIALVALUE = 42.23;
        
        JFrame f = new JFrame("MVC Demo");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        f.setLayout(new GridLayout(0,1));
        
        final Modell m = new Modell(INITIALVALUE);
        final Controller c = new Controller(m.getValue());
        m.addChangeListener(c);
        
        KontoViewCanvas canvas = new KontoViewCanvas(m.getValue(), 100, 100);
        
        canvas.addMouseWheelListener(new MouseWheelListener() {
            public void mouseWheelMoved(MouseWheelEvent e) {
                int amount = e.getWheelRotation();
                m.addValue(amount);
            }
        });
        
        c.addView(canvas);
        
        KontoViewText text = new KontoViewText(m.getValue());
        c.addView(text);
        
        f.add(canvas);
        f.add(text);
        
        f.pack();
        f.setVisible(true);
    }
}
