package menu3;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

/**
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 25.06.2007
 */
public class MenuTest {
    private JTextArea output;
    private JScrollPane scrollPane;
    
    public JMenuBar createMenuBar() {
        JMenuBar menuBar;
        JMenu menu;
        JMenuItem menuItem;
        MyMenuListener listener = new MyMenuListener(output);
        menuBar = new JMenuBar();

        menu = new JMenu("A Menu");
        menu.setMnemonic(KeyEvent.VK_A);
        menuBar.add(menu);

        menuItem = new JMenuItem("A text-only menu item", KeyEvent.VK_T);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_1, ActionEvent.ALT_MASK));
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        
        ImageIcon icon = createImageIcon("pics/duke.gif");
        menuItem = new JMenuItem(icon);
        menuItem.setMnemonic(KeyEvent.VK_D);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        
        menu.addSeparator();
        
        JMenu submenu = new JMenu("Submenu");
        submenu.setMnemonic(KeyEvent.VK_S);

        menuItem = new JMenuItem("Eintrag im Submenu");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_2, ActionEvent.ALT_MASK));
        menuItem.addActionListener(listener);
        submenu.add(menuItem);

        menuItem = new JMenuItem("Weiterer Eintrag");
        menuItem.addActionListener(listener);
        submenu.add(menuItem);
        menu.add(submenu);

        //Build second menu in the menu bar.
        menu = new JMenu("Ein weiteres Menu");
        menu.setMnemonic(KeyEvent.VK_N);
        menuBar.add(menu);

        return menuBar;

    }
    
    public Container createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
//        contentPane.setOpaque(true);

        output = new JTextArea(5, 40);
        output.setEditable(false);
        scrollPane = new JScrollPane(output);

        contentPane.add(scrollPane, BorderLayout.CENTER);

        return contentPane;
    }
    
    protected static ImageIcon createImageIcon(String path) {
        java.net.URL imgURL = MenuTest.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        } else {
            System.err.println("Couldn't find file: " + path);
            return null;
        }
    }
    
    public static void main(String[] args) {
        JFrame f = new JFrame("Menu-Test");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        MenuTest mt = new MenuTest();
        f.add(mt.createContentPane(),BorderLayout.CENTER);
        f.setJMenuBar(mt.createMenuBar());
        
        
        f.pack();
        f.setVisible(true);
        
        

    }

}
