package menu2;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

/**
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 25.06.2007
 */
public class MenuTest {
    private JTextArea output;
    private JScrollPane scrollPane;
    
    public JMenuBar createMenuBar() {
        JMenuBar menuBar;
        JMenu menu;
        JMenuItem menuItem;
        MyMenuListener listener = new MyMenuListener(output);
        menuBar = new JMenuBar();

        menu = new JMenu("A Menu");
        menu.setMnemonic(KeyEvent.VK_A);
        menuBar.add(menu);

        menuItem = new JMenuItem("A text-only menu item", KeyEvent.VK_T);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_1, ActionEvent.ALT_MASK));
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        
        menu.addSeparator();
        
        
        ImageIcon icon = createImageIcon("pics/duke.gif");
        menuItem = new JMenuItem("Text und Icon", icon);
        menuItem.setMnemonic(KeyEvent.VK_B);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        
        menuItem = new JMenuItem(icon);
        menuItem.setToolTipText("Menu nur mit Icon");
        menuItem.setMnemonic(KeyEvent.VK_D);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        
//        menu.addSeparator();
//        ButtonGroup group = new ButtonGroup();
//
//        JRadioButtonMenuItem rbMenuItem = new JRadioButtonMenuItem("Radiobutton MenuItem");
//        rbMenuItem.setSelected(true);
//        rbMenuItem.setMnemonic(KeyEvent.VK_R);
//        group.add(rbMenuItem);
//        rbMenuItem.addActionListener(listener);
//        menu.add(rbMenuItem);
//
//        rbMenuItem = new JRadioButtonMenuItem("Noch einer");
//        rbMenuItem.setMnemonic(KeyEvent.VK_O);
//        group.add(rbMenuItem);
//        rbMenuItem.addActionListener(listener);
//        menu.add(rbMenuItem);
//
//        menu.addSeparator();
//        
//        JCheckBoxMenuItem cbMenuItem = new JCheckBoxMenuItem("Checkbox MenuItem");
//        cbMenuItem.setMnemonic(KeyEvent.VK_C);
//        cbMenuItem.addItemListener(listener);
//        menu.add(cbMenuItem);
//
//        cbMenuItem = new JCheckBoxMenuItem("Noch einer");
//        cbMenuItem.setMnemonic(KeyEvent.VK_H);
//        cbMenuItem.addItemListener(listener);
//        menu.add(cbMenuItem);
        return menuBar;

    }
    
    public Container createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
//        contentPane.setOpaque(true);

        output = new JTextArea(5, 40);
        output.setEditable(false);
        scrollPane = new JScrollPane(output);

        contentPane.add(scrollPane, BorderLayout.CENTER);

        return contentPane;
    }
    
    protected static ImageIcon createImageIcon(String path) {
        java.net.URL imgURL = MenuTest.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        } else {
            System.err.println("Couldn't find file: " + path);
            return null;
        }
    }
    
    public static void main(String[] args) {
        JFrame f = new JFrame("Menu-Test");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        MenuTest mt = new MenuTest();
        f.add(mt.createContentPane(),BorderLayout.CENTER);
        f.setJMenuBar(mt.createMenuBar());
        
        
        f.pack();
        f.setVisible(true);
        
        

    }

}
