package menu1;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JMenuItem;
import javax.swing.JTextArea;

public class MyMenuListener implements ItemListener, ActionListener {
    
    JTextArea output;
    
    public MyMenuListener(JTextArea output) {
        this.output = output;
    }
    
    public void itemStateChanged(ItemEvent e) {
        JMenuItem source = (JMenuItem)(e.getSource());
        StringBuilder sb = new StringBuilder("Item event detected.");
        sb.append("\n");
        
        sb.append("    Event source: ").append(source.getText());
        sb.append(" (an instance of ").append(source.getClass().getName()).append(")\n");
        sb.append("    New state: ").append(((e.getStateChange() == ItemEvent.SELECTED) ?"selected":"unselected"));
        output.append(sb + "\n");
        output.setCaretPosition(output.getDocument().getLength());
    }
    
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)(e.getSource());
        StringBuilder sb = new StringBuilder("Action event detected.\n");
        sb.append("    Event source: ").append(source.getText());
        sb.append(" (an instance of ").append(source.getClass().getName()).append(")\n");
        output.append(sb + "\n");
        output.setCaretPosition(output.getDocument().getLength());
    }
}
