package menu1;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

/**
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 25.06.2007
 */
public class MenuTest {
    private JTextArea output;
    private JScrollPane scrollPane;
    
    public JMenuBar createMenuBar() {
        JMenuBar menuBar;
        JMenu menu;
        JMenuItem menuItem;

        menuBar = new JMenuBar();

        menu = new JMenu("A Menu");
        menu.setMnemonic(KeyEvent.VK_A);
        menuBar.add(menu);

        menuItem = new JMenuItem("A text-only menu item", KeyEvent.VK_T);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_1, ActionEvent.ALT_MASK));
        menuItem.addActionListener(new MyMenuListener(output));
        menu.add(menuItem);
        
        return menuBar;

    }
    
    public Container createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());

        output = new JTextArea(5, 40);
        output.setEditable(false);
        scrollPane = new JScrollPane(output);

        contentPane.add(scrollPane, BorderLayout.CENTER);

        return contentPane;
    }
    
    public static void main(String[] args) {
        JFrame f = new JFrame("Menu-Test");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        MenuTest mt = new MenuTest();
        f.add(mt.createContentPane(),BorderLayout.CENTER);
        f.setJMenuBar(mt.createMenuBar());
        
        
        f.pack();
        f.setVisible(true);
        
        

    }

}
