package trusted2;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

/**
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 22.06.2007
 */
@SuppressWarnings("serial")
public class TrustedApplet extends Applet {
    
    public void init() {
        add(createGUI());
    }
    
    public Panel createGUI() {
        Panel panel = new Panel();
        
        final TextArea insertTA = new TextArea();
        insertTA.setColumns(40);
        insertTA.setRows(20);
        
        panel.add(insertTA);
        
        Button writeBTO = new Button("Write");
        writeBTO.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter("C:\\TESTDATEIZUMSCHREIBEN.txt"));
                    bw.write(insertTA.getText());
                    bw.close();
                    
                } catch (FileNotFoundException e1) {
                    insertTA.setText("Datei nicht gefunden");
                } catch (IOException e2) {
                    insertTA.setText("Kann aus Datei nicht lesen");
                }  
            }
        });
        
        panel.add(writeBTO);
        return panel;
    }

    public static void main(String[] args) {
        Frame f = new Frame("Datei Schreibtest");
        f.add(new TrustedApplet().createGUI());
        
        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        
        f.pack();
        f.setVisible(true);
    }
}
