package vergleich1;

/**
 * Klasse repräsentiert einen Studenten.
 * @author Ralf Kunze, Institut für Informatik, Universität Osnabrück
 * @version 4/2007
 */
public class Student extends Person {
	
	/**
	 * Matrikelnummer des Studenten
	 */
	private int matNr;
	
	/**
	 * Default Constructor.
	 * Setzt den Namen auf <tt>NA</TT> und 
	 * die Matrikelnummer auf <tt>0</tt>
	 */
	public Student() {
		this.setName("NA");
		matNr = 0;
	}
	
	/**
	 * Custom Constructor
	 * @param name Name des Studenten
	 * @param matNr Matrikelnummer des Studenten
	 */
	public Student(String name, int matNr) {
		this.setName(name);
		this.matNr = matNr;
	}
	
	/**
	 * Setzt die Matrikelnummer eines Studenten neu.
	 * @param matNr Neue Matrikelnummer
	 */
	public void setMatNr(int matNr) {
		this.matNr = matNr;
	}
	
	/**
	 * Liefert die Matrikelnummer eines Studenten zurück.
	 * @return Matrikelnummer des Studenten
	 */
	public int getMatNr() {
		return matNr;
	}
	
	public boolean equals(Object o) {
		if (o instanceof Student) {
            return matNr == ((Student)o).matNr && this.getName().equals(((Student)o).getName());
        }
        return false;
	}
	
	public int hashCode() {
		return matNr + getName().hashCode();
	}
}
