package vergleich1;

/**
 * Klasse repräsentiert eine Person.
 * @author Ralf Kunze, Institut für Informatik, Universität Osnabrück
 * @version 4/2007
 */
public class Person {
	/**
	 * Name der Person
	 */
	private String name;
	
	/**
	 * Default Constructor, setzt den Namen auf <tt>NA</tt>.
	 */
	public Person() {
		name = "NA";
	}
	
	/**
	 * Custom Constructor.
	 * @param name Name der Person
	 */	
	public Person(String name) {
		this.name = name;
	}
	
	/**
	 * Liefert den Namen der Person zurück.
	 * @return Name der Person
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * Setzt den Namen einer Person.
	 * @param name Neuer Name der Person
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	public boolean equals(Object o) {
		if (o instanceof Person) {
            return this.getName().equals(((Person)o).getName());
        }
        return false;
	}
	
	public int hashCode() {
		return getName().hashCode();
	}
}
