package vererbung4;

/**
 * Klasse repräsentiert einen Studenten.
 * @author Ralf Kunze, Institut für Informatik, Universität Osnabrück
 * @version 4/2007
 */
public class Student extends Person {
	
	/**
	 * Matrikelnummer des Studenten
	 */
	private int matNr;
	
	/**
	 * Default Constructor.
	 * Setzt den Namen auf <tt>NA</TT> und 
	 * die Matrikelnummer auf <tt>0</tt>
	 */
	public Student() {
		this("NA", 0);
	}
	
	/**
	 * Custom Constructor
	 * @param name Name des Studenten
	 * @param matNr Matrikelnummer des Studenten
	 */
	public Student(String name, int matNr) {
		super(name);	// Konstruktor der Oberklasse
						// Ohne dies Statement wird der Default
						// Constructor der Oberklasse aufgerufen
		setMatNr(matNr);
	}
	
	/**
	 * Setzt die Matrikelnummer eines Studenten neu.
	 * @param matNr Neue Matrikelnummer
	 */
	public void setMatNr(int matNr) {
		this.matNr = matNr;
	}
	
	/**
	 * Liefert die Matrikelnummer eines Studenten zurück.
	 * @return Matrikelnummer des Studenten
	 */
	public int getMatNr() {
		return matNr;
	}

	/**
	 * Ueberschriebene Methode.
	 * @return Name des Studenten
	 */
	public String getName() {
		return "Student mit Namen: " + super.getName();
	}
	
	public String echterName() {
		return super.getName();
	}
}
