package vererbung2;

/**
 * Klasse repräsentiert einen Studenten.
 * @author Ralf Kunze, Institut für Informatik, Universität Osnabrück
 * @version 4/2007
 */
public class Student extends Person {
	
	/**
	 * Matrikelnummer des Studenten
	 */
	public int matNr;
	public String name;	// Attribut ueberdeckt <tt>name</tt> der Oberklasse
	
	/**
	 * Default Constructor.
	 * Setzt den Namen auf <tt>NA</TT> und 
	 * die Matrikelnummer auf <tt>0</tt>
	 */
	public Student() {
		this("NA", 0);
	}
	
	/**
	 * Custom Constructor
	 * @param name Name des Studenten
	 * @param matNr Matrikelnummer des Studenten
	 */
	public Student(String name, int matNr) {
		this.name = name;				// Attribut der Klasse Student
		super.name = "Klasse Person";	// Attribut der Klasse Person
		this.matNr = matNr;
	}
	
	/**
	 * Liefert das Feld Name der Oberklasse
	 * @return Feld <tt>name</tt> der Oberklasse
	 */
	public String getSuperName() {
		return super.name;
	}
}
