package observer1;

import java.util.List;
import java.util.Observable;
import java.util.Observer;

/**
 * Implementation eines Observers.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 15.06.2007
 */
public class PrintObserver implements Observer {

    private String prefix;
    
    public PrintObserver() {
        this("");
    }
    
    public PrintObserver(String prefix) {
        this.prefix = prefix;
    }
    
    
    /* (non-Javadoc)
     * @see java.util.Observer#update(java.util.Observable, java.lang.Object)
     */
    public void update(Observable o, Object arg) {
        if (arg instanceof List) {
            List l = (List) arg;
            for (Object object : l) {
                System.out.print(prefix);
                System.out.println(object);
            }
        }
        
            }

}
