package buttonlistener2;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;

/**
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 16.06.2007
 */
public class ButtonListenerTest {

    public static void main(String[] args) {
        Frame f = new Frame("ButtonListenerTest-Fenster");
        f.setLayout(new BorderLayout());

        Button bFocus = new Button("Focus");
        Button bMouse = new Button("Mouse");
        Button bMouseMotion = new Button("MouseMotion");
        Button bMouseWheel = new Button("MouseWheel");
        Button bKey = new Button("Key");

        bFocus.addFocusListener(new FocusListener() {

            public void focusGained(FocusEvent e) {
                System.out.println("Habe den Focus erhalten");
            }

            public void focusLost(FocusEvent e) {
                System.out.println("Habe den Focus verloren");
            }
        });

        bKey.addKeyListener(new KeyListener() {

            public void keyPressed(KeyEvent e) {
                System.out.print("Taste gedrückt ");
                System.out.println("mit Zeichen " + e.getKeyChar());                
            }

            public void keyReleased(KeyEvent e) {
                System.out.println("Taste losgelassen");
                System.out.println("am " + new Date(e.getWhen()));
            }

            public void keyTyped(KeyEvent e) {
                System.out.println("Taste getippt");
            }

        });

        bMouse.addMouseListener(new MouseAdapter() {

            public void mouseEntered(MouseEvent e) {
                System.out.print("Maus über dem Button ");
                System.out.printf("Button-Koordinaten der Maus: (%d|%d)%n",e.getX(),e.getY());
            }

            public void mouseExited(MouseEvent e) {
                System.out.println("Maus nicht mehr über dem Button");

            }

            public void mousePressed(MouseEvent e) {
                System.out.println("Maustaste gedrückt und zwar " + e.getButton());
            }


        });

        bMouseMotion.addMouseMotionListener(new MouseMotionListener() {

            public void mouseDragged(MouseEvent e) {
                System.out.println("Maus mit gedrückter Taste bewegt. ");
               
            }

            public void mouseMoved(MouseEvent e) {
                System.out.print("Maus bewegt ");
                System.out.printf("mit Bildschirm-Koordinaten: (%d|%d)%n", e.getXOnScreen(),e.getYOnScreen());
            }
            
        });
        
        bMouseWheel.addMouseWheelListener(new MouseWheelListener() {

            public void mouseWheelMoved(MouseWheelEvent e) {
                System.out.println("Mausrad gedreht: " + e.getWheelRotation() + " Einheiten");
            }
        });
        
        
        f.add(bFocus, BorderLayout.NORTH);
        f.add(bMouse, BorderLayout.SOUTH);
        f.add(bMouseMotion, BorderLayout.EAST);
        f.add(bMouseWheel, BorderLayout.WEST);
        f.add(bKey, BorderLayout.CENTER);

        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.pack();
        f.setVisible(true);
    }

}
