package buttonlistener1;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 16.06.2007
 */
public class ButtonListenerTest {

    public static void main(String[] args) {
        Frame f = new Frame("ButtonListenerTest-Fenster");
        f.setLayout(new BorderLayout());

        Button bFocus = new Button("Focus");
        Button bMouse = new Button("Mouse");
        Button bMouseMotion = new Button("MouseMotion");
        Button bMouseWheel = new Button("MouseWheel");
        Button bKey = new Button("Key");

        bFocus.addFocusListener(new FocusListener() {

            public void focusGained(FocusEvent e) {
                System.out.println("Habe den Focus erhalten");
            }

            public void focusLost(FocusEvent e) {
                System.out.println("Habe den Focus verloren");
            }
        });

        bKey.addKeyListener(new KeyListener() {

            public void keyPressed(KeyEvent e) {
                System.out.println("Taste gedrückt");
            }

            public void keyReleased(KeyEvent e) {
                System.out.println("Taste losgelassen");
            }

            public void keyTyped(KeyEvent e) {
                System.out.println("Taste getippt");
            }

        });

        bMouse.addMouseListener(new MouseAdapter() {

            public void mouseEntered(MouseEvent e) {
                System.out.println("Maus über dem Button");
            }

            public void mouseExited(MouseEvent e) {
                System.out.println("Maus nicht mehr über dem Button");

            }

            public void mousePressed(MouseEvent e) {
                System.out.println("Maustaste gedrückt");
            }


        });

        bMouseMotion.addMouseMotionListener(new MouseMotionListener() {

            public void mouseDragged(MouseEvent e) {
                System.out.println("Maus mit gedrückter Taste bewegt.");
            }

            public void mouseMoved(MouseEvent e) {
                System.out.println("Maus bewegt");
            }
            
        });
        
        bMouseWheel.addMouseWheelListener(new MouseWheelListener() {

            public void mouseWheelMoved(MouseWheelEvent e) {
                System.out.println("Mausrad gedreht");
            }
        });
        
        
        f.add(bFocus, BorderLayout.NORTH);
        f.add(bMouse, BorderLayout.SOUTH);
        f.add(bMouseMotion, BorderLayout.EAST);
        f.add(bMouseWheel, BorderLayout.WEST);
        f.add(bKey, BorderLayout.CENTER);

        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.pack();
        f.setVisible(true);
    }

}
