package udp1;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

/**
 * Erhaelt ein Datenpaket. Kopiert die Daten in ein eigenes Paket und packt die Zeit dazu und schickt es zum Client.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 11.06.2007
 */
public class TimeServer {
    
    private static final java.text.DateFormat DF = java.text.DateFormat
            .getDateTimeInstance();

    
    private static String getTime() {
        return DF.format(new java.util.Date());
    }

    public static void main(String[] args) {
        try {
            DatagramSocket ds = new DatagramSocket(4711);
            DatagramPacket dp = new DatagramPacket(new byte[20], 20);
            while (true) {
                ds.receive(dp);
                System.out.println("Anforderung von Port " + dp.getPort() + "  " + dp.getAddress());
                dp.setData(getTime().getBytes());
                ds.send(dp);
            }
        } catch (SocketException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}