package server2;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Date;

/**
 * Thread, der sich um einen Client kuemmert.
 * 
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 10.06.2007
 */
public class DateWriter extends Thread {

    private Socket socket;

    public DateWriter(Socket s) {
        socket = s;
    }

    public void run() {
        try {
            // Stream beschaffen
            OutputStreamWriter osw = new OutputStreamWriter(socket
                    .getOutputStream());
            
            // Schreibe Zeit in den Stream
            osw.write((new Date()).toString());
            osw.flush();

            // Tu so als obs laenger dauert
            Thread.sleep(5000);
            
            // Fertig
            osw.close();
            socket.close();
        } catch (InterruptedException e) {
        } catch (IOException e) {
            System.out.println("Socket konnte nicht erzeugt werden");
        }

    }
}
