package server1;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;

/**
 * Ein einfacher TimeServer. Anfragen werden sequentiell abgearbeitet.
 * 
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 10.06.2007
 */
public class ServerTest {

    public static void main(String[] args) {

        try {
            ServerSocket server = new ServerSocket(12345);

            // Server laeuft ewig
            for (;;) {
                Socket s = server.accept(); // Verbindung akzeptieren
                System.out.println("Habe eine Verbindung mit Socket: " + s);
                
                // Stream besorgen und Zeit schicken
                OutputStreamWriter osw = new OutputStreamWriter(s.getOutputStream());
                osw.write((new Date()).toString());
                osw.flush();
                try {  // Wir tun so, als obs laenger dauert
                    Thread.sleep(5000);
                } catch (InterruptedException e) {
                }
                // Socket schliessen
                osw.close();
                s.close();
            }

        } catch (IOException e) {
            System.out.println("Socket konnte nicht erzeugt werden");
        }
    }

}
