package url1;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * Demonstriert das URL-Objekt und welche Daten ausgelesen werden koennen.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 07.06.2007
 */
public class URLTest {

    public static void main(String[] args) {
        URL url;
        try {
            // Achtung: Hier wird noch keine Verbindung aufgebaut
            url = new URL("http://www.inf.uos.de/index.php");
//            url = new URL("http://de.selfhtml.org/html/referenz/elemente.htm#inline_elemente");
//            url = new URL("http", "www.google.de", 80, "index.html");
//            url = new URL("http://www.google.de/search?source=ig&hl=de&q=java&btnG=Google-Suche&meta=");
//            url = new URL("INFOB://www.inf.uos.de/index.php");
            System.out.println("Protocol        : " + url.getProtocol() ); 
            System.out.println("Hostname        : " + url.getHost() ); 
            System.out.println("Port            : " + url.getPort() );
            System.out.println("Dateiname/Query : " + url.getFile() ); 
            System.out.println("Pfad            : " + url.getPath() ); 
            System.out.println("Query-String    : " + url.getQuery() ); 
            System.out.println("Anker           : " + url.getRef() );
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } 
        

    }

}
