package socket5;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 * Laden einer Webseite mittels einer Scoektverbindung.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 06.06.2007
 */
public class SocketTest {

    public static void main(String[] args) {
        String hostname = null;
        String seite = null;
        int port = 80;
        
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        
        // Daten einlesen
        try {
            System.out.print("Bitte geben sie einen Hostname ein: ");
            hostname = br.readLine();
            
            System.out.print("Bitte geben sie eine Webseite ein: ");
            seite = br.readLine();
        } catch (IOException e1) {
            System.err.println("Could not read from stdin. Bye!");
            System.exit(1);
        }
        
        
        try {
            // Socket socket = new Socket(InetAddress.getByName(hostname), port);
            Socket socket = new Socket(hostname, port);
            
            System.out.println("Connection established: " + socket);
            OutputStreamWriter out = new OutputStreamWriter(socket.getOutputStream());
            BufferedReader     in  = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                           
            // GET Aufruf an den Webserver
            out.write("GET "+ seite + " \r\n\r\n");
//            out.write("GET "+ seite + " HTTP/1.0\r\n\r\n");
            out.flush();
            System.out.println("Query sent");
            
            // Ergebnis auslesen und auf System.out schreiben
            String s;
            while((s = in.readLine()) != null) {
                System.out.println(s);
            }
            
            out.close();
            in.close();
            socket.close();
            
        } catch (UnknownHostException e) {
            System.err.println("Host " + hostname + " nicht bekannt!");
        } catch (IOException e) {
            System.err.println("Kann nicht von Host " + hostname + " lesen!");
        }
    }

}
