package socket3;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 * Demonstriert die Kommunikation mit einem echo Server.
 * 
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 06.06.2007
 */
public class SocketTest {

    public static void main(String[] args) {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String hostname = null;
        int port = 7; // echo
        
        // Hostname einlesen
        try {
            System.out.print("Bitte geben sie einen Hostname ein: ");
            hostname = br.readLine();
        } catch (IOException e1) {
            System.err.println("Could not read from stdin. Bye!");
            System.exit(1);
        }

        try {
            // Socket socket = new Socket(InetAddress.getByName(hostname), port);

            // Socketverbindung aufbauen
            final Socket socket = new Socket(hostname, port);
            System.out.println(socket);

            // Streams beschaffen
            final InputStream in = socket.getInputStream();
            OutputStreamWriter out = new OutputStreamWriter(socket.getOutputStream());

            // Neuen Thread erzeugen, der Daten vom Server liest und auf System.out schreibt
            Thread readerThread = new Thread() {
                public void run() {
                    int len = 0;
                    byte[] b = new byte[1024];
                    try {
                        while (!isInterrupted() && (len = in.read(b)) != -1) {
                            if (!isInterrupted()) {
                                System.out.write(b, 0, len);
                            }
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                    System.err.println("Reader ist zuende!");
                }
            };

            readerThread.start();

            String eingabe = null;
            
            // Daten von System.in lesen und an den Echo-Server schicken
            do {
                eingabe = br.readLine();
                if (eingabe != null) {
                    out.write(eingabe + "\n");
                    out.flush();
                } else {
                    readerThread.interrupt();
                    out.write("end");
                    out.flush();
                }
            } while (eingabe != null);

            try {
                readerThread.join();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            in.close();
            out.close();
            socket.close();

        } catch (UnknownHostException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
