package socket2_improved;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;

/**
 * Thread, der testet, ob ein Port verfuegbar ist.
 * Ist dies der Fall wird die Portnummer und der zugehoerige Socket in einer Map gespeichert.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 06.06.2007
 */
public class SocketTestThread extends Thread {
    private InetAddress inet;
    private int port;
    private Socket socket;
    private Map<Integer,Socket> map;
    
    public SocketTestThread(InetAddress address, int port, Map<Integer,Socket> map) {
        inet = address;
        this.port = port;
        this.map = map;
    }
    
    public void run() {
        try {
            socket = new Socket(inet, port);
            
            // Falls Socketverbindung geklappt hat in die Map eintragen
            map.put(port, socket);
            socket.close();
            
        } catch(UnknownHostException e1) {
            // do nothing and be quiet
        } catch(ConnectException e2) {
            // do nothing and be quiet            
        }catch (IOException e3) {
            // do nothing and be quiet
        } 
        
    }
}
