package socket2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 * Es wird getestet, welche Ports bei einem Rechner offen sind.
 * 
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 06.06.2007
 */
public class PortsAvailableTest {

    public static void main(String[] args) {

        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String hostname = null;

        // Hostname einlesen
        try {
            System.out.print("Bitte geben sie einen Hostname ein: ");
            hostname = br.readLine();
        } catch (IOException e1) {
            System.err.println("Could not read from stdin. Bye!");
            System.exit(1);
        }

        InetAddress address = null;

        // InetAddress erzeugen
        try {
            address = InetAddress.getByName(hostname);
        } catch (UnknownHostException e) {
            System.err.println("Host " + hostname + " not found. Bye!");
            System.exit(1);
        }
        
        // Ports ablaufen
        System.out.println("Available ports:");
        for (int i = 0; i < 100; i++) {
            Socket s;
            try {
                System.out.println("Teste Port " + i);
                s = new Socket(address, i);
                
                // Falls Socket aufgebaut werden konnte ist der Port offen, ansonsten IOException
                System.out.println("\t Port available: " + s);
                s.close();
            } catch (IOException e) {
                // Be quiet
            }

        }
    }

}
