package socket1;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 * Ein Socket zu einem Host an einem Port oeffnen.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 06.06.2007
 */
public class SocketTest {

    public static void main(String[] args) {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String hostname = null;
        int port = 0;
        
        // Daten einlesen
        try {
            System.out.print("Bitte geben sie einen Hostname ein: ");
            hostname = br.readLine();
            
            System.out.print("Bitte geben sie einen Port ein: ");
            port = Integer.parseInt(br.readLine());
        } catch (IOException e1) {
            System.err.println("Could not read from stdin. Bye!");
            System.exit(1);
        } catch(NumberFormatException e2) {
            System.out.println("Port is not a valid number!");
            System.exit(1);
        }

        // Socket oeffnen
        try {
            // Socket socket = new Socket(InetAddress.getByName(hostname), port);
            
            // Hier wird direkt eine Verbindung aufgebaut
            Socket socket = new Socket(hostname, port);
            System.out.println(socket);
            socket.close();
            
        } catch (UnknownHostException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

}
