package inetaddress1;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * Demonstriert die Erzeugung eines InetAddress-Objektes anhand eines Hostnamens.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 06.06.2007
 */
public class InetAddressTest {

    public static void main(String[] args) {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String hostname = null;
        
        // Hostname einlesen
        try {
            System.out.print("Bitte geben sie einen Hostname ein: ");
            hostname = br.readLine();
        } catch (IOException e1) {
            System.err.println("Could not read from stdin. Bye!");
            System.exit(1);
        }
        
        // InetAddress-Objekt erzeugen und ausgeben
        try {
            InetAddress address = InetAddress.getByName(hostname);
            System.out.println(address);
        } catch (UnknownHostException e) {
            System.err.println("Der Host ist nicht bekannt");
            System.exit(2);
        }
    }

}
