package visitor1;

/**
 * Das Interface Visitable wird von Datenstrukturen implementiert, die einen
 * Visitor zulassen.
 * 
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 21.05.2007
 */
public interface Visitable {
	/**
	 * Bekommt einen Visitor uebergeben, der die Datenstruktur besuchen moechte.
	 * 
	 * @param v Der Besucher (Visitor)
	 * @return true, wennd er Visitor immer true geliefert hat, sonst false
	 */
	boolean visit(Visitor v);
}
