package nestedtoplevel1;

/**
 * Demonstration einer nested top-level class.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 21.05.2007
 */
public class Aussen {
	private String wert1;
	private static String aussenKlasse = "AUSSEN";
	private String name;
	private Innen i;
	
	static public class Innen {
		private String wert1;
		private static String innenKlasse = "INNEN";
		private Aussen a;
		
		public Innen(String wert1) {
			this.wert1 = wert1;
			a = new Aussen("wert1","name");
		}
		
		public String toString() {
			StringBuilder sb = new StringBuilder();
			
			sb.append("Mein Wert lautet: ").append(wert1);
			
			// Zugriff auf die aeussere Klassenvariable moeglich
			sb.append(" ich befinde mich innerhalb von ").append(aussenKlasse);
			// sb.append(" des Modells").append(name); // Zugriff auf name nicht erlaubt, da nicht statisch!
			return sb.toString();
		}
	}
	
	public Aussen(String wert1, String name) {
		this.name = name;
		this.wert1 = wert1;
		i = new Innen("wert1");
	}
	
	public String toString() {
		StringBuilder sb = new StringBuilder();
		
		sb.append("Mein Wert lautet: ").append(wert1).append("\n");
		sb.append("Mein Name lautet").append(name).append("\n");
		
		// Zugriff auf die innere Klassenvariable moeglich
		sb.append("Meine innere Klasse heisst").append(Innen.innenKlasse).append("\n");
		return sb.toString();
	}
}
